'use strict';
/**
 * Start the real script.
 */
require(['jquery'], function ($) {

  /**
   * Page initialization
   */
  $(document).ready(function() {

    /**
     * Handle the notification email interval
     */
    $('.notificationEmailInterval').change(function () {
      var intervalSelect = $(this);
      var notification = new XWiki.widgets.Notification("\u0412\u0430\u0448\u0438 \u043D\u0430\u0441\u0442\u0440\u043E\u0439\u043A\u0438 \u0441\u043E\u0445\u0440\u0430\u043D\u044F\u044E\u0442\u0441\u044F ...", 'inprogress');
      var serviceURL = new XWiki.Document(XWiki.Model.resolve('XWiki.Notifications.Code.NotificationPreferenceService', XWiki.EntityType.DOCUMENT)).getURL('get', 'outputSyntax=plain');
      $.post(serviceURL, {
        'interval': intervalSelect.val()
      }).done(function (data) {
        notification.hide();
        new XWiki.widgets.Notification("\u0421\u043E\u0445\u0440\u0430\u043D\u0435\u043D\u043E!", 'done');
      });
    });

    /**
     * Handle the include diff in email setting
     */
    $('.notificationEmailDiffType').change(function () {
      var diffTypeSelect = $(this);
      var notification = new XWiki.widgets.Notification("\u0412\u0430\u0448\u0438 \u043D\u0430\u0441\u0442\u0440\u043E\u0439\u043A\u0438 \u0441\u043E\u0445\u0440\u0430\u043D\u044F\u044E\u0442\u0441\u044F ...", 'inprogress');
      var serviceURL = new XWiki.Document(XWiki.Model.resolve('XWiki.Notifications.Code.NotificationPreferenceService', XWiki.EntityType.DOCUMENT)).getURL('get', 'outputSyntax=plain');
      $.post(serviceURL, {
        'diffType': diffTypeSelect.val(),
        'target': $('.notifEmailPreferences').attr('data-target')
      }).done(function (data) {
        notification.hide();
        new XWiki.widgets.Notification("\u0421\u043E\u0445\u0440\u0430\u043D\u0435\u043D\u043E!", 'done');
      }).fail(function (data) {
        notification.hide();
        new XWiki.widgets.Notification("\u041D\u0435 \u0443\u0434\u0430\u043B\u043E\u0441\u044C \u0441\u043E\u0445\u0440\u0430\u043D\u0438\u0442\u044C \u043D\u0430\u0441\u0442\u0440\u043E\u0439\u043A\u0438", 'error');
      });
    });

  });
});

